/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.gui.common;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.awt.print.PageFormat;
import java.awt.print.Pageable;
import java.awt.print.Printable;
import java.awt.print.PrinterException;

public class Vista
implements Pageable {
    private int mNumPagesX;
    private int mNumPagesY;
    private int mNumPages;
    private Printable mPainter;
    private PageFormat mFormat;

    public Vista(float f, float f2, Printable printable, PageFormat pageFormat) {
        this.setPrintable(printable);
        this.setPageFormat(pageFormat);
        this.setSize(f, f2);
    }

    protected Vista() {
    }

    protected void setPrintable(Printable printable) {
        this.mPainter = printable;
    }

    protected void setPageFormat(PageFormat pageFormat) {
        this.mFormat = pageFormat;
    }

    protected void setSize(float f, float f2) {
        this.mNumPagesX = (int)(((double)f + this.mFormat.getImageableWidth() - 1.0) / this.mFormat.getImageableWidth());
        this.mNumPagesY = (int)(((double)f2 + this.mFormat.getImageableHeight() - 1.0) / this.mFormat.getImageableHeight());
        this.mNumPages = this.mNumPagesX * this.mNumPagesY;
    }

    public int getNumberOfPages() {
        return this.mNumPages;
    }

    protected PageFormat getPageFormat() {
        return this.mFormat;
    }

    public PageFormat getPageFormat(int n) throws IndexOutOfBoundsException {
        if (n >= this.mNumPages) {
            throw new IndexOutOfBoundsException();
        }
        return this.getPageFormat();
    }

    public Printable getPrintable(int n) throws IndexOutOfBoundsException {
        if (n >= this.mNumPages) {
            throw new IndexOutOfBoundsException();
        }
        double d = (double)(n % this.mNumPagesX) * this.mFormat.getImageableWidth();
        double d2 = (double)(n / this.mNumPagesX) * this.mFormat.getImageableHeight();
        Point2D.Double double_ = new Point2D.Double(d, d2);
        return new TranslatedPrintable(this.mPainter, double_);
    }

    public static final class TranslatedPrintable
    implements Printable {
        private Printable mPainter;
        private Point2D mOrigin;

        public TranslatedPrintable(Printable printable, Point2D point2D) {
            this.mPainter = printable;
            this.mOrigin = point2D;
        }

        public int print(Graphics graphics, PageFormat pageFormat, int n) throws PrinterException {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.translate(-this.mOrigin.getX(), -this.mOrigin.getY());
            this.mPainter.print(graphics2D, pageFormat, 1);
            return 0;
        }
    }
}

